/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	Behavior
**
** DESCRIPTION:	
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef BEHAVIOR_H
#define BEHAVIOR_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "../Collectables/Collectable.h"
#include "../Puzzles/Construction.h"
#include "../Utils/theStringManager.h"

class CVillager;

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/

/******************************************************************************\
** TYPE DEFINITIONS
\******************************************************************************/
enum EBehavior
{
	eBehavior_Idle,
	eBehavior_SwimSW,
	eBehavior_PaceSoCent,
	eBehavior_DoResearch,
	eBehavior_HugSprite,
	eBehavior_WaitForContact,
	eBehavior_GoInHouse,
	eBehavior_RunAway,
	eBehavior_Dance,
	eBehavior_Construct,
	eBehavior_HonorTheDead,
	eBehavior_Fishing,
	eBehavior_RainDance,
	eBehavior_Relaxing,
	eBehavior_School,

	eBehavior_GatherKindling,
	eBehavior_GatherFirewood,
	eBehavior_StartFire,
	eBehavior_CircleDance,

	eBehavior_WashFeet2,
	eBehavior_DrinkWater,
	eBehavior_StrollingBeach, 
	eBehavior_WanderCemetery, 
	eBehavior_HangOutPool, 
	eBehavior_HangOutBeach,

	eBehavior_CuriousRobe,
	eBehavior_CuriousStatue,
	eBehavior_CuriousDoor,
	eBehavior_CuriousClam,
	eBehavior_CuriousHive,
	eBehavior_CuriousLift,
	eBehavior_CuriousRuins,
	eBehavior_CuriousBath,
	eBehavior_CuriousAlchLab,
	eBehavior_CuriousFire,
	eBehavior_CuriousHangingKey,
	eBehavior_CuriousOrchard,
	eBehavior_CuriousHerb1,
	eBehavior_CuriousHerb2,
	eBehavior_CuriousHerb3,
	eBehavior_CuriousHerb4,
	eBehavior_CuriousHerb5,
	eBehavior_CuriousDryGrass,
	eBehavior_CuriousRoster,

	eBehavior_Confused,
	eBehavior_NotFeelingWell2,
	eBehavior_Dive,
	eBehavior_PickShroom,
	eBehavior_PickCollectable,
	eBehavior_ShakeHead,
	eBehavior_Worry,
	eBehavior_HealSprite,
	eBehavior_Sit,
	eBehavior_Interact,
	eBehavior_WalkCircle,
	eBehavior_GoToSchoolPopLow,
	eBehavior_GoToSchoolPopHigh,
	eBehavior_Lecture,
	eBehavior_Coffee,
	eBehavior_SciFair,
	eBehavior_DrinkingRain,
	eBehavior_DoingLaundry,
	eBehavior_EvilTwin,
	eBehavior_BlessingsDayDance,
	eBehavior_BlessingsDayDanceII,
	eBehavior_DayOfTheDeadDance,
	eBehavior_IsolaDayDance,
	eBehavior_MagicDance,
	eBehavior_StompAnts,
	eBehavior_HideInHut,
	eBehavior_BringBackFoodPrize,
	eBehavior_BringBackFoodPrizeSlow,
	eBehavior_RescueCrowdToBeach,

	eBehavior_StudyTigerLily,
	eBehavior_StudyPitcherPlant,
	eBehavior_StudyBlueRose,
	eBehavior_StudyBlackOrchid,
	eBehavior_StudyPurpleDaisy,
	eBehavior_StudyWaxPlant,
	eBehavior_LeaveOcean,
	eBehavior_SwimLagoon,
	eBehavior_BuryDead,
	eBehavior_CelebrateEvent,
	eBehavior_RepairLoveshack,
	eBehavior_Eat,
	eBehavior_Danceparty,
	eBehavior_InspectingHut ,
	eBehavior_RepairHut,
	eBehavior_HonorTheStatue,
	eBehavior_GenericSlowWander,
	eBehavior_GenericWarming,
	eBehavior_KidPlayTag,
	eBehavior_KidPlaySeeSaw,
	eBehavior_KidSpaz,
	eBehavior_NatureCalls ,
	eBehavior_TellStory,
	eBehavior_ListenStory,
	eBehavior_RestInHospital,
	eBehavior_ChangeClothes ,
	eBehavior_AssembleAtTable,
	eBehavior_Blessings,
	eBehavior_Sneezing,
	eBehavior_Lonely ,
	eBehavior_WashBaby ,
	eBehavior_ChangeBaby ,
	eBehavior_ShowBaby ,
	eBehavior_ObserveAdults ,
	eBehavior_GetHoney,
	eBehavior_RepairRainLift,
	eBehavior_UseRainLift,
	eBehavior_RepairBath,
	eBehavior_DoAlchemy,
	eBehavior_EmptyPot,
	eBehavior_DrinkPotion,
	eBehavior_Refuse,
	eBehavior_GatherHerbs,
	eBehavior_ConstructStatueScaffolding,
	eBehavior_PushStatue,
	eBehavior_WorryAboutFood,
	eBehavior_FailAtChief,
	eBehavior_BecomeChief,
	eBehavior_NotBecomeChief,
	eBehavior_SwimInBath,
	eBehavior_Bored,
	eBehavior_PlantTree,
	eBehavior_HarvestFruit,
	eBehavior_SmokeBees,
	eBehavior_ClearRubble,
	eBehavior_ClearLeaves,

	eBehavior_ChiefSupervise,
	eBehavior_ChiefInspectingFood,
	eBehavior_ChiefLookingGloriousAtFire,
	eBehavior_ChiefWeatherDance,
	eBehavior_ChiefDramaticPathStanding,
	eBehavior_ChiefInspectingScience,

	eBehavior_ChiefGrantFood, 
	eBehavior_ChiefMassiveCure,
	eBehavior_ChiefSpawnRare,
	eBehavior_ChiefConcernedAboutSick,
	eBehavior_ChiefThinkingInAmp, 

	eBehavior_WashFaceInSpring,
	eBehavior_WashHandsInSpring,
	eBehavior_GettingOutOfRain,

	eBehavior_BatheInSpring,
	eBehavior_GetADrink,
	eBehavior_LookForMushrooms,
	eBehavior_PointingAtReef,
	eBehavior_JumpForKey,
	eBehavior_Stumbling,
	eBehavior_SwimmingWithFish,
	eBehavior_DoingExercise,
	eBehavior_PlayWithOtters,
	eBehavior_Faint,
	eBehavior_TooCold,
	eBehavior_TooHot,
	eBehavior_Itchy,
	eBehavior_Paralyzed,
	eBehavior_PortableFrenzy,
	eBehavior_LayDown,
	eBehavior_SitDown,
	eBehavior_Spirituality,
	eBehavior_Trance,
	eBehavior_JellyfishPanic,
	eBehavior_DropVialInOcean,
	eBehavior_LookingForAGrownUp,
	eBehavior_LookingForAGrownUp2,
	eBehavior_HuddleAroundFire,
	eBehavior_DrawPlans,
	eBehavior_ShowBabyBees,
	eBehavior_ShowBabyHerbs,
	eBehavior_ExamineAHut,
	eBehavior_HidingSomething,
	eBehavior_SpringCleaning,
	eBehavior_ShowBabyOrchard,
	eBehavior_DoAromatherapy,
	eBehavior_LightBurners,
	eBehavior_SwapPearlForKey,
	eBehavior_DepositInFoodBin,
	eBehavior_ShowBabyAmphetheater,
	eBehavior_SunningChildByBeach,
	eBehavior_ChildrenPlayInPuddles,
	eBehavior_SecretlyPracticing,
	eBehavior_GarlicBreath,
	eBehavior_BubbleBreath, 
	eBehavior_Hiccup, 
	eBehavior_HiccupInCenter, 
	eBehavior_GarlicInCenter, 
	eBehavior_BubblesInCenter, 
	eBehavior_BadDancing,
	eBehavior_StudyMedicine,
	eBehavior_PlayInDirt,
	eBehavior_GoneCrazy,
	eBehavior_Blind,
	eBehavior_GatherForSweetDrink,
	eBehavior_MomTeachingTalk,
	eBehavior_PlayingInSand,
	eBehavior_CleaningAfterStorm,
	eBehavoir_QuelchFire,
	eBehavior_ShapePearlForKey,
	eBehavior_PolishPearlForKey,

	eBehavior_NumberOf
};

struct SBehaviorData
{
};

struct SConstructionData : SBehaviorData
{
	//structure data
	EConstruction	m_eConstruction;

	//structure methods
	//setup
	public:		SConstructionData(EConstruction eConstruction) { m_eConstruction = eConstruction; }
};

struct SEventData : SBehaviorData
{
	//structure data
	int			m_iEvent;
	bool		m_bPlaySound;

	//structure methods
	//setup
	public:		SEventData(const int iEvent, const bool bPlaySound) { m_iEvent = iEvent; m_bPlaySound = bPlaySound; }
};

struct SGatherHerbsData : SBehaviorData
{
	//structure data
	ECarrying	m_eHerb;

	//structure methods
	//setup
	public:		SGatherHerbsData(ECarrying eHerb) { m_eHerb = eHerb; }
};

struct SHarvestFruitData : SBehaviorData
{
	//structure data
	int			m_iTree;

	//structure methods
	//setup
	public:		SHarvestFruitData(int iTree) { m_iTree = iTree; }
};

struct SPickUpData : SBehaviorData
{
	//structure data
	ECarrying	m_eCarrying;

	//structure methods
	//setup
	public:		SPickUpData(ECarrying eCarrying) { m_eCarrying = eCarrying; }
};

struct SPlantTreeData : SBehaviorData
{
	//structure data
	ldwPoint	m_sTreePos;

	//structure methods
	//setup
	public:		SPlantTreeData(ldwPoint sTreePos) { m_sTreePos = sTreePos; }
};

struct SPosData : SBehaviorData
{
	//structure data
	ldwPoint	m_sPos;

	//structure methods
	//setup
	public:		SPosData(ldwPoint sPos) { m_sPos = sPos; }
};

struct SRefuseData : SBehaviorData
{
	//structure data
	StringId	m_eSay;
	int			m_iValue;

	//structure methods
	//setup
	public:		SRefuseData(StringId eSay, const int iValue = -1) { m_eSay = eSay; m_iValue = iValue; }
};

struct SStringData : SBehaviorData
{
	//structure data
	StringId	m_eStringId;

	//structure methods
	//setup
	public:		SStringData(StringId eStringId) { m_eStringId = eStringId; }
};

typedef void (* LPBEHAVIORMACRO)(CVillager &Villager);
typedef void (* LPBEHAVIORMACROWITHDATA)(CVillager &Villager, const SBehaviorData &sData);
typedef void (* LPBEHAVIORMACROWITHPOSDATA)(CVillager &Villager, const SPosData &sData);
typedef void (* LPBEHAVIORMACROWITHCONSTRUCTIONDATA)(CVillager &Villager, const SConstructionData &sData);
typedef void (* LPBEHAVIORMACROWITHEVENTDATA)(CVillager &Villager, const SEventData &sData);
typedef void (* LPBEHAVIORMACROWITHGATHERHERBSDATA)(CVillager &Villager, const SGatherHerbsData &sData);
typedef void (* LPBEHAVIORMACROWITHHARVESTFRUITDATA)(CVillager &Villager, const SHarvestFruitData &sData);
typedef void (* LPBEHAVIORMACROWITHPICKUPDATA)(CVillager &Villager, const SPickUpData &sData);
typedef void (* LPBEHAVIORMACROWITHPLANTTREEDATA)(CVillager &Villager, const SPlantTreeData &sData);
typedef void (* LPBEHAVIORMACROWITHREFUSEDATA)(CVillager &Villager, const SRefuseData &sData);
typedef void (* LPBEHAVIORMACROWITHSTRINGDATA)(CVillager &Villager, const SStringData &sData);

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CBehavior
{
	friend class CVillager;

private:

	//class structures
	struct SBehavior
	{
		LPBEHAVIORMACRO			m_pMacro;
		bool					m_bRequiresData;
	};

	//class data
	SBehavior				m_sBehavior[eBehavior_NumberOf];

	StringId				m_sayWhat;
	bool					m_needsPositioning;
	int						m_buildWhat;
	int						m_howLong;
	int						m_whichTarget;
	int						m_whichHut;
	int						m_whichEvent;
	bool					m_startsSound;
	int						m_whichIngredient;
	ldwPoint				m_totemPos;

	//class methods
	//setup
	public:		CBehavior(void);

	// process
	protected:	const bool BeginNewBehavior(CVillager &Villager, const EBehavior eBehavior, const SBehaviorData &sData = SBehaviorData()) const;
	private:	static void Idle(CVillager &Villager);
	private:	static void SwimSW (CVillager &Villager);
	private:	static void PaceSoCent(CVillager &Villager);
	private:	static void DoResearch(CVillager &Villager);
	private:	static void HugSprite(CVillager &Villager);
	private:	static void WaitForContact (CVillager &Villager);
	private:	static void GoInHouse(CVillager &Villager);
	private:	static void RunAway(CVillager &Villager, const SStringData &sData);
	private:	static void Dance(CVillager &Villager);
	private:	static void Construct(CVillager &Villager, const SConstructionData &sData);
	private:	static void HonorTheDead(CVillager &Villager);
	private:	static void Fishing(CVillager &Villager);
	private:	static void RainDance(CVillager &Villager);
	private:	static void Relaxing(CVillager &Villager);
	private:	static void School(CVillager &Villager); //10_23_06
	private:	static void FoundSchool(CVillager &Villager);
	private:	static void GatherKindling(CVillager &Villager);
	private:	static void GatherFirewood(CVillager &Villager);
	private:	static void StartFire(CVillager &Villager);
	private:	static void CircleDance(CVillager &Villager);
	
	private:	static void WashFeet2(CVillager &Villager);
	private:	static void DrinkWater(CVillager &Villager);
	private:	static void StrollingBeach(CVillager &Villager); 
	private:	static void WanderCemetery(CVillager &Villager); 
	private:	static void HangOutPool(CVillager &Villager); 
	private:	static void HangOutBeach(CVillager &Villager);

	private:	static	void ChiefInspectingFood(CVillager &Villager);
	private:	static	void ChiefLookingGloriousAtFire(CVillager &Villager);
	private:	static	void ChiefWeatherDance(CVillager &Villager);
	private:	static	void ChiefDramaticPathStanding(CVillager &Villager);
	private:	static	void ChiefInspectingScience(CVillager &Villager);

	private:	static	void ChiefGrantFood(CVillager &Villager);
	private:	static	void ChiefMassiveCure(CVillager &Villager);
	private:	static	void ChiefConcernedAboutSick(CVillager &Villager);
	private:	static	void ChiefThinkingInAmp(CVillager &Villager);
	private:	static  void ChiefSpawnRare(CVillager &Villager);

	private:	static void CuriousRobe(CVillager &Villager);
	private:	static void CuriousStatue(CVillager &Villager);
	private:	static void CuriousDoor(CVillager &Villager);
	private:	static void CuriousClam(CVillager &Villager);
	private:	static void CuriousHive(CVillager &Villager);
	private:	static void CuriousLift(CVillager &Villager);
	private:	static void CuriousRuins(CVillager &Villager);
	private:	static void CuriousBath(CVillager &Villager);
	private:	static void CuriousAlchLab(CVillager &Villager);
	private:	static void CuriousFire(CVillager &Villager);
	private:	static void CuriousHangingKey(CVillager &Villager);
	private:	static void CuriousOrchard(CVillager &Villager);
	private:	static void CuriousHerb1(CVillager &Villager);
	private:	static void CuriousHerb2(CVillager &Villager);
	private:	static void CuriousHerb3(CVillager &Villager);
	private:	static void CuriousHerb4(CVillager &Villager);
	private:	static void CuriousHerb5(CVillager &Villager);
	private:	static void CuriousDryGrass(CVillager &Villager);
	private:	static void CuriousRoster(CVillager &Villager);

	private:	static void Confused(CVillager &Villager, const SStringData &sData);
	private:	static void NotFeelingWell(CVillager &Villager);
	private:	static void NotFeelingWell2(CVillager &Villager);
	private:	static void Dive(CVillager &Villager);
	private:	static void PickShroom(CVillager &Villager, const SPickUpData &sData);
	private:	static void PickCollectable(CVillager &Villager, const SPickUpData &sData);
	private:	static void ShakeHead(CVillager &Villager);
	private:	static void Worry(CVillager &Villager);
	private:	static void HealSprite(CVillager &Villager);
	private:	static void UncoverMosaic(CVillager &Villager);
	private:	static void Sit(CVillager &Villager);
	private:	static void Interact(CVillager &Villager);
	private:	static void WalkCircle(CVillager &Villager);
	private:	static void GoToSchoolPopLow(CVillager &Villager);
	private:	static void GoToSchoolPopHigh(CVillager &Villager);
	private:	static void Lecture(CVillager &Villager);
	private:	static void Coffee(CVillager &Villager);
	private:	static void SciFair(CVillager &Villager);
	private:	static void NotFeelingWell3(CVillager &Villager);
	private:	static void NotFeelingWell4(CVillager &Villager);
	private:	static void DrinkingRain(CVillager &Villager);
	private:	static void DoingLaundry(CVillager &Villager);
	private:	static void EvilTwin(CVillager &Villager);
	private:	static void BlessingsDayDance (CVillager &Villager);
	private:	static void BlessingsDayDanceII (CVillager &Villager);
	private:	static void DayOfTheDeadDance (CVillager &Villager);
	private:	static void IsolaDayDance (CVillager &Villager);
	private:	static void MagicDance (CVillager &Villager);
	private:	static void StompAnts (CVillager &Villager);
	private:	static void HideInHut (CVillager &Villager);
	private:	static void BringBackFoodPrize (CVillager &Villager);
	private:	static void BringBackFoodPrizeSlow (CVillager &Villager);
	private:	static void RescueCrowdToBeach (CVillager &Villager);

	private:	static void StudyTigerLily(CVillager &Villager);
	private:	static void StudyPitcherPlant(CVillager &Villager);
	private:	static void StudyBlueRose(CVillager &Villager);
	private:	static void StudyBlackOrchid(CVillager &Villager);
	private:	static void StudyPurpleDaisy(CVillager &Villager);
	private:	static void StudyWaxPlant(CVillager &Villager);
	private:	static void LeaveOcean(CVillager &Villager);
	private:	static void SwimLagoon(CVillager &Villager);
	private:	static void BuryDead(CVillager &Villager);
	private:	static void Exercising(CVillager &Villager);
	private:	static void CelebrateEvent(CVillager &Villager, const SEventData &sData);
	private:	static void RepairLoveshack(CVillager &Villager);
	private:	static void Eat(CVillager &Villager);
	private:	static void Danceparty(CVillager &Villager);
	private:	static void InspectingHut(CVillager &Villager, const SConstructionData &sData);
	private:	static void RepairHut (CVillager &Villager, const SConstructionData &sData);
	private:	static void HonorTheStatue(CVillager &Villager);
	private:	static void GenericSlowWander(CVillager &Villager);
	private:	static void GenericWarming(CVillager &Villager);
	private:	static void KidPlayTag(CVillager &Villager);
	private:	static void KidPlaySeeSaw(CVillager &Villager);
	private:	static void KidSpaz(CVillager &Villager);
	private:	static void NatureCalls (CVillager &Villager);
	private:	static void TellStory(CVillager &Villager);
	private:	static void ListenStory(CVillager &Villager);
	private:	static void RestInHospital(CVillager &Villager);
	private:	static void ChangeClothes (CVillager &Villager);

	private:	static void AssembleAtTable(CVillager &Villager);
	private:	static void Blessings(CVillager &Villager);
	private:	static void Sneezing(CVillager &Villager);
	private:	static void Lonely(CVillager &Villager);
	private:	static void WashBaby(CVillager &Villager);
	private:	static void ChangeBaby(CVillager &Villager);
	private:	static void ShowBaby(CVillager &Villager);
	private:	static void ObserveAdults(CVillager &Villager);
	private:	static void SwimInBath(CVillager &Villager);
	private:	static void GetHoney(CVillager &Villager);
	private:	static void RepairRainLift(CVillager &Villager);
	private:	static void UseRainLift(CVillager &Villager);
	private:	static void RepairBath(CVillager &Villager);
	private:	static void DoAlchemy(CVillager &Villager);
	private:	static void DrinkPotion(CVillager &Villager);
	private:	static void Refuse(CVillager &Villager, const SRefuseData &sData);
	private:	static void GatherHerbs(CVillager &Villager, const SGatherHerbsData &sData);
	private:	static void ConstructStatueScaffolding(CVillager &Villager);
	private:	static void PushStatue(CVillager &Villager);
	private:	static void WorryAboutFood(CVillager &Villager);
	private:	static void FailAtChief(CVillager &Villager);
	private:	static void BecomeChief(CVillager &Villager);
	private:	static void NotBecomeChief(CVillager &Villager);
	private:	static void Bored(CVillager &Villager);
	private:	static void PlantTree(CVillager &Villager, const SPlantTreeData &sData);
	private:	static void HarvestFruit(CVillager &Villager, const SHarvestFruitData &sData);
	private:	static void SmokeBees(CVillager &Villager);
	private:	static void JumpForKey(CVillager &Villager);
	private:	static void ClearRubble(CVillager &Villager);
	private:	static void ClearLeaves(CVillager &Villager);
	private:	static void ChiefSupervise(CVillager &Villager);
	private:	static void WashFaceInSpring(CVillager &Villager);
	private:	static void WashHandsInSpring(CVillager &Villager);
	private:	static void BatheInSpring(CVillager &Villager);
	private:	static void GetADrink(CVillager &Villager);
	private:	static void LookForMushrooms(CVillager &Villager);
	private:	static void PointingAtReef(CVillager &Villager);
	private:	static void Stumbling(CVillager &Villager);
	private:	static void SwimmingWithFish(CVillager &Villager);
	private:	static void DoingExercise(CVillager &Villager);
	private:	static void PlayWithOtters(CVillager &Villager);
	private:	static void Faint(CVillager &Villager);
	private:	static void TooHot(CVillager &Villager);
	private:	static void TooCold(CVillager &Villager);
	private:	static void Itchy(CVillager &Villager);
	private:	static void Paralyzed(CVillager &Villager);

				//some new alch bevs. april 21 arthur
	private:	static void GarlicBreath(CVillager &Villager);
	private:	static void BubbleBreath(CVillager &Villager);
	private:	static void Hiccup(CVillager &Villager);
	private:	static void HiccupInCenter(CVillager &Villager);
	private:	static void GarlicInCenter(CVillager &Villager);
	private:	static void BubblesInCenter(CVillager &Villager);
	private:	static void PlayInDirt(CVillager &Villager);
	private:	static void GoneCrazy(CVillager &Villager);
	private:	static void Blind(CVillager &Villager);
	private:	static void GatherForSweetDrink(CVillager &Villager);
	private:	static void MomTeachingTalk(CVillager &Villager);

	private:	static void BadDancing(CVillager &Villager);
	private:	static void LayDown(CVillager &Villager);
	private:	static void SitDown(CVillager &Villager);
	private:	static void Spirituality(CVillager &Villager);
	private:	static void Trance(CVillager &Villager);
	private:	static void DropVialInOcean(CVillager &Villager);
	private:	static void EmptyPot(CVillager &Villager);
	private:	static void LookingForAGrownUp(CVillager &Villager);
	private:	static void LookingForAGrownUp2(CVillager &Villager);
	private:	static void ChildrenPlayInPuddles(CVillager &Villager);
	private:	static void HuddleAroundFire(CVillager &Villager);

	private:	static void ShowBabyBees(CVillager &Villager);
	private:	static void ShowBabyHerbs(CVillager &Villager);
	private:	static void HidingSomething(CVillager &Villager);

	private:	static void SpringCleaning(CVillager &Villager);
	private:	static void ShowBabyOrchard(CVillager &Villager);
	private:	static void ShowBabyAmphetheater(CVillager &Villager);
	private:	static void SunningChildByBeach(CVillager &Villager);
	private:	static void SecretlyPracticing(CVillager &Villager);			
	private:	static void ExamineAHut(CVillager &Villager);

	private:	static void DrawPlans(CVillager &Villager);
	private:	static void DoAromatherapy(CVillager &Villager);
	private:	static void LightBurners(CVillager &Villager);
	private:	static void SwapPearlForKey(CVillager &Villager);
	private:	static void DepositInFoodBin(CVillager &Villager);

	private:	static void StudyMedicine(CVillager &Villager);

	private:	static void GettingOutOfRain(CVillager &Villager);
	private:	static void PortableFrenzy (CVillager &Villager, int x, int y);//, const char *behaviorLabel);
	private:	static void JellyfishPanic(CVillager &Villager);

	private:	static void PlayingInSand(CVillager &Villager);
	private:	static void CleaningAfterStorm(CVillager &Villager);
	private:	static void QuelchFire(CVillager &Villager);
    private:    static void ShapePearlForKey(CVillager &Villager);
    private:    static void PolishPearlForKey(CVillager &Villager);

	// access
	public:		void SetMacro(const EBehavior eBehavior, const LPBEHAVIORMACRO pMacro);
	public:		void SetMacro(const EBehavior eBehavior, const LPBEHAVIORMACROWITHDATA pMacro);

	public:		void SetMacro(const EBehavior eBehavior, const LPBEHAVIORMACROWITHPOSDATA pMacro) { SetMacro(eBehavior, (LPBEHAVIORMACROWITHDATA)pMacro); };
	public:		void SetMacro(const EBehavior eBehavior, const LPBEHAVIORMACROWITHCONSTRUCTIONDATA pMacro) { SetMacro(eBehavior, (LPBEHAVIORMACROWITHDATA)pMacro); }
	public:		void SetMacro(const EBehavior eBehavior, const LPBEHAVIORMACROWITHEVENTDATA pMacro) { SetMacro(eBehavior, (LPBEHAVIORMACROWITHDATA)pMacro); }
	public:		void SetMacro(const EBehavior eBehavior, const LPBEHAVIORMACROWITHGATHERHERBSDATA pMacro) { SetMacro(eBehavior, (LPBEHAVIORMACROWITHDATA)pMacro); }
	public:		void SetMacro(const EBehavior eBehavior, const LPBEHAVIORMACROWITHHARVESTFRUITDATA pMacro) { SetMacro(eBehavior, (LPBEHAVIORMACROWITHDATA)pMacro); }
	public:		void SetMacro(const EBehavior eBehavior, const LPBEHAVIORMACROWITHPICKUPDATA pMacro) { SetMacro(eBehavior, (LPBEHAVIORMACROWITHDATA)pMacro); }
	public:		void SetMacro(const EBehavior eBehavior, const LPBEHAVIORMACROWITHPLANTTREEDATA pMacro) { SetMacro(eBehavior, (LPBEHAVIORMACROWITHDATA)pMacro); }
	public:		void SetMacro(const EBehavior eBehavior, const LPBEHAVIORMACROWITHREFUSEDATA pMacro) { SetMacro(eBehavior, (LPBEHAVIORMACROWITHDATA)pMacro); }
	public:		void SetMacro(const EBehavior eBehavior, const LPBEHAVIORMACROWITHSTRINGDATA pMacro) { SetMacro(eBehavior, (LPBEHAVIORMACROWITHDATA)pMacro); }

	public:		bool NeedsPositioning() { return m_needsPositioning; }
	public:		void SetNeedsPositioning(bool needsPositioning) { m_needsPositioning = needsPositioning; }
	public:		int HowLong() { return m_howLong; }
	public:		void SetHowLong(int howLong) { m_howLong = howLong; }
	public:		int WhichTarget() { return m_whichTarget; }
	public:		void SetWhichTarget(int whichTarget) { m_whichTarget = whichTarget; }
	public:		int WhichHut() { return m_whichHut; }
	public:		void SetWhichHut(int whichHut) { m_whichHut = whichHut; }
	//public:		ldwPoint TotemPos() { return m_totemPos; }
	//public:		void SetTotemPos(ldwPoint totemPos) { m_totemPos = totemPos; }
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CBehavior		Behavior;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/